
<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                <?php echo lang('hospital'); ?>  <?php echo lang('today_sales'); ?> 
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table ">

                <div class="space15"></div>
                    <table class="table table-stock">
                        <thead>
                            <tr> 
                                <th class="th-crimson"><?php echo lang('on_current_page'); ?></th> 
                                <th class="th-green"><?php echo lang('invoice'); ?>: <span id="total_invoice"></span></th>                              
                                <th class="th-green"><?php echo lang('gross_total'); ?>: <span id="total_gross"></span> <?php echo $settings->currency; ?></th>
                                <th class="th-indigo"><?php echo lang('paid'); ?> <?php echo lang('amount'); ?>: <span id="total_paid_amount"></span> <?php echo $settings->currency; ?></th>
                                <th class="th-black"><?php echo lang('due'); ?> <?php echo lang('amount'); ?>: <span id="total_due_amount"></span> <?php echo $settings->currency; ?></th>
                                <th class="th-green"><?php echo lang('doctor'); ?> <?php echo lang('commission'); ?>: <span id="total_commission"></span> <?php echo $settings->currency; ?></th>
                            </tr>            
                    </table>

                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th> <?php echo lang('invoice'); ?> </th>
                                <th> <?php echo lang('date'); ?> </th>
                                <th> <?php echo lang('sub_total'); ?> (<?php echo $settings->currency; ?>)</th>
                                <th> <?php echo lang('discount'); ?></th>
                                <th> <?php echo lang('gross_total'); ?> (<?php echo $settings->currency; ?>)</th>
                                <th> <?php echo lang('amount_received'); ?> (<?php echo $settings->currency; ?>)</th>                                
                                <th> <?php echo lang('due'); ?> (<?php echo $settings->currency; ?>)</th>
                                <th> <?php echo lang('commission'); ?> (<?php echo $settings->currency; ?>)</th>
                                <th> <?php echo lang('done_by'); ?> </th>
                                <th class="option_th"> <?php echo lang('options'); ?> </th>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($payments as $payment) { ?>
                            <?php $patient_info = $this->db->get_where('patient', array('id' => $payment->patient))->row(); ?>

                            <tr class="">
                                <td><?php echo $payment->id; ?></td>
                                <td><?php echo date('d-M-Y h:i A', $payment->date); ?></td>
                                <td> <?php echo number_format($payment->amount); ?></td> 
                                <td><?php 
                                echo $payment->discount_from.' ('.$payment->discount.')';
                                ?></td>             
                                <td> <?php echo number_format($payment->gross_total); ?></td>
                                <td><?php $amount_deposited=$this->finance_model->getDepositAmountByPaymentId($payment->id);
                                echo number_format($amount_deposited);
                                ?></td>
                                <td> <?php echo number_format($payment->gross_total - $amount_deposited); ?></td>
                                <td> <?php 
                                echo number_format($payment->doctor_amount);
                                ?></td>
                                <td><?php echo $this->db->get_where('users', array('id' => $payment->user))->row()->username;?></td>
                                <td> 
                                    <a target="_blank" class="btn btn-xs invoicebutton width_auto" style="color: #fff;" href="finance/invoice?id=<?php echo $payment->id; ?>"><i class="fa fa-file-text"></i>  <?php echo lang('invoice'); ?></a>
                                    <?php if ($this->ion_auth->in_group('admin')) { ?> 
                                        <a class="btn btn-info btn-xs delete_button width_auto" href="finance/delete?id=<?php echo $payment->id; ?>" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash-o"></i>  <?php echo lang('delete'); ?></a>
                                    <?php } ?>
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<script>
                                    $(document).ready(function () {
                                        $(".flashmessage").delay(3000).fadeOut(100);
                                    });
</script>


<script>
    $(document).ready(function () {
        var table = $('#editable-sample').DataTable({
            responsive: true,
            drawCallback: function () {

                $('#total_invoice').html($('#editable-sample').DataTable().rows(':visible').nodes().length);
                $('#total_gross').html($('#editable-sample').DataTable().column(4 , {page:'current'}).data().sum().toLocaleString());
                $('#total_paid_amount').html($('#editable-sample').DataTable().column(5, {page:'current'}).data().sum().toLocaleString());
                $('#total_due_amount').html($('#editable-sample').DataTable().column(6, {page:'current'}).data().sum().toLocaleString());
                $('#total_commission').html($('#editable-sample').DataTable().column(7, {page:'current'}).data().sum().toLocaleString());
      }	,

            dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [
                'excelHtml5',
                'pdfHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [0, 1, 2,3,4,5,6,7,8],
                    }
                },
            ],

            aLengthMenu: [
                [100, -1],
                [100, "All"]
            ],
            iDisplayLength: -1,
            "order": [[0, "desc"]],

            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                searchPlaceholder: "Search...",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json"
            },

        });

        table.buttons().container()
                .appendTo('.custom_buttons');
    });
</script>

<style>
 .table {
    margin-bottom: 0px;
 }
</style>