<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Surgery extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('surgery_model');
        $this->load->model('patient/patient_model');
        $this->load->model('finance/finance_model');
        $this->load->model('doctor/doctor_model');
        if (!$this->ion_auth->in_group(array('admin', 'Doctor', 'Accountant', 'Receptionist'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data['surgerys'] = $this->surgery_model->getSurgery();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('surgery', $data);
        $this->load->view('home/footer'); // just the header file  
    }

    public function addSurgeryView() {
        $data = array();
        $data['services'] = $this->finance_model->getPaymentCategory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_surgery_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addSurgery() {
        $patient = $this->input->post('patient');
        $guardian = $this->input->post('guardian');
        $surgeon = $this->input->post('surgeon');
        $assistant = $this->input->post('assistant');
        $anaestheasist = $this->input->post('anaestheasist');
        $indication = $this->input->post('indication');
        $incision = $this->input->post('incision');
        $findings = $this->input->post('findings');
        $others = $this->input->post('others');
        $anaes_f = $this->input->post('anaes_f');
        $operation = $this->input->post('operation');
        $status = $this->input->post('status');
   
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('patient', 'Patient', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('guardian', 'Guardian', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('surgeon', 'Surgeon', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('assistant', 'Assistant', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('anaestheasist', 'Anaestheasist', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('indication', 'Indication', 'trim|required|min_length[1]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('incision', 'Incision', 'trim|required|min_length[1]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('findings', 'Findings', 'trim|required|min_length[1]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('others', 'Others', 'trim|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('anaes_f', 'Anaesthesia', 'trim|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('operation', 'Operation', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('status', 'Status', 'trim|required|min_length[1]|max_length[100]|xss_clean');
       
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('add_surgery_view', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $user = $this->ion_auth->get_user_id();
            $data = array();
            $patientDetails = $this->patient_model->getPatientById($patient);
            $data = array(
                'patient' => $patient,                             
                'patient_name' => $patientDetails->name,
                'patient_phone' => $patientDetails->phone,
                'surgeon' => $surgeon,
                'assistant_1' => $assistant,
                'anaestheasist' => $anaestheasist,
                'indication' => $indication,
                'incision' => $incision,
                'findings' => $findings,
                'others' => $others,
                'anaes_f' => $anaes_f,
                'operation' => $operation,
                'status' => $status,
                'add_date' => time(),
                'added_by' => $user,
            );

                $this->surgery_model->insertSurgery($data);
                $guardian_info = array('guardian' => $guardian);
                $this->patient_model->updatePatient($patient, $guardian_info);
                $this->session->set_flashdata('feedback', lang('added'));
            redirect('surgery');
        }
    }

    function editSurgeryByJason() {
        $id = $this->input->get('id');
        $data['surgery'] = $this->surgery_model->getSurgeryById($id);
        $data['operation'] = $this->finance_model->getPaymentCategoryById($data['surgery']->operation)->category;
        $data['surgeon'] = $this->doctor_model->getDoctorById($data['surgery']->surgeon)->name.', '.lang('id').': '. $data['surgery']->surgeon;
        echo json_encode($data);
    }

    public function editSurgery() {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
   
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('id', 'Id', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('status', 'Status', 'trim|required|min_length[1]|max_length[100]|xss_clean');
       
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('surgery', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $user = $this->ion_auth->get_user_id();
            $data = array();
            $data = array(
                'status' => $status,
                'update_date' => time(),
                'updated_by' => $user,
            );

            if (!empty($id)) 
            {
                $this->surgery_model->updateSurgery($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('surgery');
        }
    }

    function deleteSurgery() {
        $id = $this->input->get('id');
        $this->surgery_model->deleteSurgery($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('surgery');
    }

    function getSurgeryList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "operation",
            "4" => "surgeon",
            "6" => "status",
            "7" => "add_date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if (!empty($search)) {
                $data['surgerys'] = $this->surgery_model->getSurgeryByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['surgerys'] = $this->surgery_model->getSurgeryByLimit($limit, $start, $order, $dir);
        }

        foreach ($data['surgerys'] as $surgery) {
            $patientdetails = $surgery->patient_name. ', '. $surgery->patient_phone. ', ID: '.  $surgery->patient;
            $guardian = $this->patient_model->getPatientById($surgery->patient)->guardian;
         
            if ($this->ion_auth->in_group('admin')) {
                $option3 = '<a class="btn btn-danger btn-xs btn_width" href="surgery/deleteSurgery?id=' . $surgery->id . '&surgery_id=' .$surgery->surgery_id . '" onclick="return confirm(\'Are you sure you want to delete this surgery?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
            }

            $option4='<a target="_blank" class="btn btn-info btn-xs invoicebutton" title="' . lang('print') . '" style="color: #fff;" href="surgery/printConsent?id=' . $surgery->id . '"><i class="fa fa-file"></i> ' . lang('print').' '. lang('consent') . '</a>';
            $option2='<button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="' . $surgery->id . '"><i class="fa fa-edit"> </i> ' . lang('edit').' '. lang('status') . '</button>';
          
            $info[] = array(
                $surgery->id,
                $this->finance_model->getPaymentCategoryById($surgery->operation)->category,
                $patientdetails,
                $guardian,
                $this->doctor_model->getDoctorById($surgery->surgeon)->name.', '.lang('id').': '. $surgery->surgeon,
                $this->doctor_model->getDoctorById($surgery->anaestheasist)->name.', '.lang('id').': '. $surgery->anaestheasist,
                $surgery->status,              
                date('d-m-Y h:i A',$surgery->add_date),
                $this->db->get_where('users', array('id' => $surgery->added_by))->row()->username,                
                $option4.' '.$option2.' '.$option3,
            );
        }

        if (!empty($data['surgerys'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('surgery'),
                "recordsFiltered" => $this->db->count_all_results('surgery'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }
        echo json_encode($output);
    }

    function printConsent() {
        $id = $this->input->get('id');
        $data['surgery'] = $this->surgery_model->getSurgeryById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('print_consent', $data);
        $this->load->view('home/footer'); // just the footer fi
    }
}

/* End of file surgery.php */
/* Location: ./application/modules/surgery/controllers/surgery.php */
