<!--sidebar end-->
<!--main content start-->
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<section id="main-content"> 
    <section class="wrapper site-min-height">
        <!--state overview start-->
        <div class="col-md-12">
            <div class="row state-overview" style="padding: 3px 0px;">
                <div class="col-md-10">
                    <!--custom chart start-->

                    <?php
                    $currently_processing_year = date('Y', $first_minute);
                    $next_year = $currently_processing_year + 1;
                    $previous_year = $currently_processing_year - 1;
                    ?>

                    <div class="panel-heading"> <?php echo date('Y', $first_minute) . ' ' .lang('hospital').' '. lang('expense_report'); ?> 
                        
                        <div class="col-md-1 pull-right no-print">
                            <a class="no-print pull-right" onclick="javascript:window.print();"> <i class="fa fa-print"></i>  </a>
                        </div>
                        <div class="col-md-1 pull-right no-print">
                            <a href="finance/monthlyExpense?year=<?php echo $next_year; ?>">
                                <i class="fa fa-arrow-right"></i>
                            </a>
                        </div>
                        <div class="col-md-1 pull-right no-print">
                            <a href="finance/monthlyExpense?year=<?php echo $previous_year; ?>">
                                <i class="fa fa-arrow-left"></i>
                            </a>
                        </div>
                    </div>
                    <div  id="chart_div" style="height:310px"></div>




                    <div class="panel-body">
                        <div class="adv-table editable-table ">

                            <div class="space15"></div>
                            <table class="table table-striped table-hover table-bordered" id="editable-sample1">
                                <thead>
                                    <tr>
                                        <th> <?php echo lang('date'); ?> </th>
                                        <th> <?php echo lang('amount'); ?> (<?php echo $this->currency; ?>)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    for ($month = 1; $month <= 12; $month++) {
                                        $time = mktime(12, 0, 0, $month, 1, $year);
                                        if (!empty($all_expenses[date('m-Y', $time)])) {
                                            if (date('Y', $time) == $year) {
                                                $month_name = date('F', $time);
                                                $amount = $all_expenses[date('m-Y', $time)];
                                            }
                                        } else {
                                            if (date('Y', $time) == $year) {
                                                $month_name = date('F', $time);
                                                $amount = 0;
                                            }
                                        }

                                        if (!empty($all_salaries[date('m-Y', $time)])) {
                                            if (date('Y', $time) == $year) {
                                                $month_name = date('F', $time);
                                                $salary = $all_salaries[date('m-Y', $time)];
                                            }
                                        } else {
                                            if (date('Y', $time) == $year) {
                                                $month_name = date('F', $time);
                                                $salary = 0;
                                            }
                                        }
                                        ?>
                                    
                                        <tr>
                                            <td><?php echo $month_name; ?></td>
                                            <td><?php echo number_format($amount+$salary, 0, '.', ','); ?></td>
                                            <?php $total_amount[] = $amount+$salary; ?>
                                        </tr>

                                        <?php
                                    }
                                    ?>
                                        
                                         <?php
                                    if (!empty($total_amount)) {
                                        $total_amount = array_sum($total_amount);
                                    } else {
                                        $total_amount = 0;
                                    }
                                    ?>

                                    <tr style="color: #000 !important; font-weight: bold;">
                                        <td><?php echo lang('total'); ?></td> 
                                        <td><?php echo number_format($total_amount, 0, '.', ','); ?></td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!--state overview end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->
<!--footer end-->

</section>

<script type="text/javascript">
    google.charts.load('current', {'packages': ['corechart']});
    google.charts.setOnLoadCallback(drawVisualization);

    function drawVisualization() {
        // Some raw data (not necessarily accurate)
        var data = google.visualization.arrayToDataTable([
            ['Month', 'Expense'],
            ['Jan', <?php echo $this_year['expense_per_month']['january']+$this_year['staffSalary_per_month']['january']; ?>],
            ['Feb', <?php echo $this_year['expense_per_month']['february']+$this_year['staffSalary_per_month']['february']; ?>],
            ['Mar', <?php echo $this_year['expense_per_month']['march']+$this_year['staffSalary_per_month']['march']; ?>],
            ['Apr', <?php echo $this_year['expense_per_month']['april']+$this_year['staffSalary_per_month']['april']; ?>],
            ['May', <?php echo $this_year['expense_per_month']['may']+$this_year['staffSalary_per_month']['may']; ?>],
            ['June', <?php echo $this_year['expense_per_month']['june']+$this_year['staffSalary_per_month']['june']; ?>],
            ['July', <?php echo $this_year['expense_per_month']['july']+$this_year['staffSalary_per_month']['july']; ?>],
            ['Aug', <?php echo $this_year['expense_per_month']['august']+$this_year['staffSalary_per_month']['august']; ?>],
            ['Sep', <?php echo $this_year['expense_per_month']['september']+$this_year['staffSalary_per_month']['september']; ?>],
            ['Oct', <?php echo $this_year['expense_per_month']['october']+$this_year['staffSalary_per_month']['october']; ?>],
            ['Nov', <?php echo $this_year['expense_per_month']['november']+$this_year['staffSalary_per_month']['november']; ?>],
            ['Dec', <?php echo $this_year['expense_per_month']['december']+$this_year['staffSalary_per_month']['december']; ?>],
        ]);

        var options = {
            //title: new Date().getFullYear() + ' <?php echo lang('per_month_income_expense'); ?>',
            vAxis: {title: '<?php echo $settings->currency; ?>'},
            hAxis: {title: '<?php echo lang('months'); ?>'},
            seriesType: 'bars',
            colors:['red'],
            series: {5: {type: 'line'}}
        };

        var chart = new google.visualization.ComboChart(document.getElementById('chart_div'));
        chart.draw(data, options);
    }
</script>



</body>
</html>
